<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Terms & Conditions</title>
    <meta name="viewport" content="width=device-width, initial-scale=1"> {{-- needed for mobile --}}
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    .about-gradient {
      background: linear-gradient(to right, #f8f9fa, #e3f2fd); /* soft gray to light blue */
    }

  .container ul li a {
   text-decoration: none; 
   background: linear-gradient(to right, #ffecd2, #fcb69f); 
   -webkit-background-clip: text;
    -webkit-text-fill-color: transparent; 
    font-weight: 800; 
  transition: color 0.3s ease;
}
.container ul li::after{
    content: '';
    width: 0%;
    height: 2px;
    background: goldenrod;
    display: block;
        margin: auto;
        transition: 0.5s;
}
.container ul li:hover::after{
    width: 100%;
}
.navbar-brand{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.dropdown-menu{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
}
.display-5{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.btn-primary{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  border: none;
}
.mb-4.text-center{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.btn-secondary{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  border: none;
}
  </style>
</head>
<body class="bg-light">

{{-- NAVBAR --}}
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container">
    {{-- Logo / Brand --}}
    <a class="navbar-brand fw-bold" href="{{ route('posts.index') }}">
      Candid Chronicles
    </a>

    {{-- Mobile toggle --}}
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMain"
            aria-controls="navbarMain" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    {{-- Menu --}}
    <div class="collapse navbar-collapse" id="navbarMain">
      <ul class="navbar-nav ms-auto mb-2 mb-lg-0">

        {{-- Home --}}
        <li class="nav-item">
          <a href="{{ route('posts.index') }}"
             class="nav-link {{ request()->routeIs('posts.index') ? 'active' : '' }}">
            Home
          </a>
        </li>

        {{-- About (dynamic page) --}}
        <li class="nav-item">
          <a href="{{ route('about') }}"
             class="nav-link {{ request()->routeIs('about') ? 'active' : '' }}">
            About
          </a>
        </li>

        {{-- Categories dropdown: News / Story / Lifestyle --}}
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle {{ request()->routeIs('category.show') ? 'active' : '' }}"
             href="#" id="navbarDropdown" role="button"
             data-bs-toggle="dropdown" aria-expanded="false">
            Categories
          </a>
          <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
            <li><a class="dropdown-item" href="{{ route('category.show', 'news') }}">News</a></li>
            <li><a class="dropdown-item" href="{{ route('category.show', 'story') }}">Story</a></li>
            <li><a class="dropdown-item" href="{{ route('category.show', 'lifestyle') }}">Lifestyle</a></li>
          </ul>
        </li>

        {{-- Archive (link to current year archive) --}}
        <li class="nav-item">
          <a href="{{ route('archive.year', now()->year) }}"
             class="nav-link {{ request()->routeIs('archive.*') ? 'active' : '' }}">
            Archive
          </a>
        </li>

        {{-- Contact --}}
        <li class="nav-item">
          <a href="{{ route('contact') }}"
             class="nav-link {{ request()->routeIs('contact') ? 'active' : '' }}">
            Contact
          </a>
        </li>

        {{-- Admin Login / Dashboard --}}
        <li class="nav-item ms-lg-3">
          @if(auth('admin')->check())
            <a href="{{ route('admin.posts.index') }}" class="btn btn-outline-light btn-sm me-2">
              Admin Dashboard
            </a>
            <form action="{{ route('admin.logout') }}" method="POST" class="d-inline">
              @csrf
              <button type="submit" class="btn btn-danger btn-sm">Logout</button>
            </form>
          @else
            <a href="{{ route('admin.login') }}" class="btn btn-outline-light btn-sm">
              Admin Login
            </a>
          @endif
        </li>

      </ul>
    </div>
  </div>
</nav>

<div class="container py-5">
    <h1>Terms & Conditions</h1>

    <p>
        By accessing and using this website, you accept and agree to be bound
        by the terms and provisions of this agreement.
    </p>

    <h5>Use of Content</h5>
    <p>
        All content on this website is for informational purposes only.
        We make no representations as to the accuracy or completeness of
        any information.
    </p>

    <h5>Intellectual Property</h5>
    <p>
        All content published on this website, including text, images,
        and media, is the property of the site owner unless otherwise stated.
    </p>

    <h5>Third-Party Links</h5>
    <p>
        This website may contain links to third-party websites.
        We are not responsible for the content or practices of those sites.
    </p>

    <h5>Limitation of Liability</h5>
    <p>
        We shall not be held liable for any damages arising from the use
        of this website.
    </p>

    <h5>Changes to These Terms</h5>
    <p>
        We reserve the right to update these Terms at any time without notice.
    </p>
</div>
<footer class="py-4 bg-dark text-light mt-auto">
  <div class="container d-flex flex-column flex-md-row justify-content-between align-items-center">
    <div>
      © {{ date('Y') }} Candid Chronicles. All rights reserved.
    </div>
    <div class="mt-2 mt-md-0">
      <a href="https://twitter.com/CandidChro4351" class="text-light text-decoration-none me-3">Twitter</a>
      <a href="https://www.instagram.com/candid_chronicles00/" class="text-light text-decoration-none me-3">Instagram</a>
      <a href="https://www.facebook.com/share/1CW8Pn4ws9/?mibextid=wwXIfr" class="text-light text-decoration-none">Facebook</a>
    </div>
<div class="mt-2 mt-md-0">
    <a href="{{ route('privacy.policy') }}">Privacy Policy</a>
    | <a href="{{ route('terms') }}">Terms & Conditions</a>
  |
<a href="{{ route('contact') }}">Contact</a>
</div>

  </div>
  
</footer>

{{-- Bootstrap JS (required for navbar toggle + dropdowns) --}}
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>