<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Contact Us - Candid Chronicles</title>
  <meta name="viewport" content="width=device-width, initial-scale=1"> {{-- important for mobile --}}
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
  <style>
     .container ul li a {
   text-decoration: none; 
   background: linear-gradient(to right, #ffecd2, #fcb69f); 
   -webkit-background-clip: text;
    -webkit-text-fill-color: transparent; 
    font-weight: 800; 
  transition: color 0.3s ease;
}
.container ul li::after{
    content: '';
    width: 0%;
    height: 2px;
    background: goldenrod;
    display: block;
        margin: auto;
        transition: 0.5s;
}
.container ul li:hover::after{
    width: 100%;
}
.navbar-brand{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.dropdown-menu{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
}
.display-5{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.btn-primary{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  border: none;
}
.mb-4.text-center{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.btn-secondary{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  border: none;
}
    </style>
{{-- NAVBAR --}}

<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container">
    <a class="navbar-brand fw-bold" href="{{ route('posts.index') }}">Candid Chronicles</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMain">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navbarMain">
      <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
        <li class="nav-item"><a href="{{ route('posts.index') }}" class="nav-link">Home</a></li>
        <li class="nav-item"><a href="{{ route('about') }}" class="nav-link">About</a></li>

        {{-- Categories dropdown --}}
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button"
             data-bs-toggle="dropdown" aria-expanded="false">
            Categories
          </a>
          <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
            <li><a class="dropdown-item" href="{{ route('category.show', 'news') }}">News</a></li>
            <li><a class="dropdown-item" href="{{ route('category.show', 'story') }}">Story</a></li>
            <li><a class="dropdown-item" href="{{ route('category.show', 'lifestyle') }}">Lifestyle</a></li>
          </ul>
        </li>

        <li class="nav-item"><a href="{{ route('contact') }}" class="nav-link active">Contact</a></li>
      </ul>
    </div>
  </div>
</nav>

<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-8">

      <h1 class="mb-4 text-center">Contact Us</h1>
      <p class="text-center text-muted mb-5">
        Have a story, feedback, or partnership inquiry? Fill the form below and we’ll get back to you.
      </p>

      {{-- Success Message --}}
      @if(session('success'))
        <div class="alert alert-success">
          {{ session('success') }}
        </div>
      @endif

      {{-- Validation Errors --}}
      @if($errors->any())
        <div class="alert alert-danger">
          <ul class="mb-0">
            @foreach($errors->all() as $error)
              <li>{{ $error }}</li>
            @endforeach
          </ul>
        </div>
      @endif

      <div class="card shadow-sm">
        <div class="card-body">
          <form action="{{ route('contact.send') }}" method="POST" novalidate>
            @csrf

            <div class="mb-3">
              <label for="name" class="form-label">Your Name</label>
              <input
                type="text"
                class="form-control @error('name') is-invalid @enderror"
                id="name"
                name="name"
                value="{{ old('name') }}"
                required
              >
              @error('name')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="mb-3">
              <label for="email" class="form-label">Your Email</label>
              <input
                type="email"
                class="form-control @error('email') is-invalid @enderror"
                id="email"
                name="email"
                value="{{ old('email') }}"
                required
              >
              @error('email')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="mb-3">
              <label for="subject" class="form-label">Subject</label>
              <input
                type="text"
                class="form-control @error('subject') is-invalid @enderror"
                id="subject"
                name="subject"
                value="{{ old('subject') }}"
                required
              >
              @error('subject')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="mb-3">
              <label for="message" class="form-label">Message</label>
              <textarea
                class="form-control @error('message') is-invalid @enderror"
                id="message"
                name="message"
                rows="5"
                required
              >{{ old('message') }}</textarea>
              @error('message')
                <div class="invalid-feedback">{{ $message }}</div>
              @enderror
            </div>

            <div class="d-grid">
              <button type="submit" class="btn btn-primary btn-lg">
                Send Message
              </button>
            </div>
          </form>
        </div>
      </div>

      <div class="text-center mt-4 text-muted">
        Or email us directly at <strong>candidchronicles@yahoo.com</strong>
      </div>

    </div>
  </div>
</div>

<footer class="py-4 bg-dark text-light mt-auto">
  <div class="container d-flex flex-column flex-md-row justify-content-between align-items-center">
    <div>
      © {{ date('Y') }} Candid Chronicles. All rights reserved.
    </div>
    <div class="mt-2 mt-md-0">
      <a href="https://twitter.com/CandidChro4351" class="text-light text-decoration-none me-3">Twitter</a>
      <a href="https://www.instagram.com/candid_chronicles00/" class="text-light text-decoration-none me-3">Instagram</a>
      <a href="https://www.facebook.com/share/1CW8Pn4ws9/?mibextid=wwXIfr" class="text-light text-decoration-none">Facebook</a>
    </div>
    <div class="mt-2 mt-md-0">
    <a href="{{ route('privacy.policy') }}">Privacy Policy</a>
    | <a href="{{ route('terms') }}">Terms & Conditions</a>
  |
<a href="{{ route('contact') }}">Contact</a>
  </div>

  </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
