<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>About – Candid Chronicles</title>
  <meta name="viewport" content="width=device-width, initial-scale=1"> {{-- needed for mobile --}}
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    .about-gradient {
      background: linear-gradient(to right, #f8f9fa, #e3f2fd); /* soft gray to light blue */
    }

  .container ul li a {
   text-decoration: none; 
   background: linear-gradient(to right, #ffecd2, #fcb69f); 
   -webkit-background-clip: text;
    -webkit-text-fill-color: transparent; 
    font-weight: 800; 
  transition: color 0.3s ease;
}
.container ul li::after{
    content: '';
    width: 0%;
    height: 2px;
    background: goldenrod;
    display: block;
        margin: auto;
        transition: 0.5s;
}
.container ul li:hover::after{
    width: 100%;
}
.navbar-brand{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.dropdown-menu{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
}
.display-5{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.btn-primary{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  border: none;
}
.mb-4.text-center{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.btn-secondary{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  border: none;
}
  </style>
</head>
<body class="bg-light">

{{-- NAVBAR --}}
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container">
    {{-- Logo / Brand --}}
    <a class="navbar-brand fw-bold" href="{{ route('posts.index') }}">
      Candid Chronicles
    </a>

    {{-- Mobile toggle --}}
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMain"
            aria-controls="navbarMain" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    {{-- Menu --}}
    <div class="collapse navbar-collapse" id="navbarMain">
      <ul class="navbar-nav ms-auto mb-2 mb-lg-0">

        {{-- Home --}}
        <li class="nav-item">
          <a href="{{ route('posts.index') }}"
             class="nav-link {{ request()->routeIs('posts.index') ? 'active' : '' }}">
            Home
          </a>
        </li>

        {{-- About (dynamic page) --}}
        <li class="nav-item">
          <a href="{{ route('about') }}"
             class="nav-link {{ request()->routeIs('about') ? 'active' : '' }}">
            About
          </a>
        </li>

        {{-- Categories dropdown: News / Story / Lifestyle --}}
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle {{ request()->routeIs('category.show') ? 'active' : '' }}"
             href="#" id="navbarDropdown" role="button"
             data-bs-toggle="dropdown" aria-expanded="false">
            Categories
          </a>
          <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
            <li><a class="dropdown-item" href="{{ route('category.show', 'news') }}">News</a></li>
            <li><a class="dropdown-item" href="{{ route('category.show', 'story') }}">Story</a></li>
            <li><a class="dropdown-item" href="{{ route('category.show', 'lifestyle') }}">Lifestyle</a></li>
          </ul>
        </li>

        {{-- Archive (link to current year archive) --}}
        <li class="nav-item">
          <a href="{{ route('archive.year', now()->year) }}"
             class="nav-link {{ request()->routeIs('archive.*') ? 'active' : '' }}">
            Archive
          </a>
        </li>

        {{-- Contact --}}
        <li class="nav-item">
          <a href="{{ route('contact') }}"
             class="nav-link {{ request()->routeIs('contact') ? 'active' : '' }}">
            Contact
          </a>
        </li>

        {{-- Admin Login / Dashboard --}}
        <li class="nav-item ms-lg-3">
          @if(auth('admin')->check())
            <a href="{{ route('admin.posts.index') }}" class="btn btn-outline-light btn-sm me-2">
              Admin Dashboard
            </a>
            <form action="{{ route('admin.logout') }}" method="POST" class="d-inline">
              @csrf
              <button type="submit" class="btn btn-danger btn-sm">Logout</button>
            </form>
          @else
            <a href="{{ route('admin.login') }}" class="btn btn-outline-light btn-sm">
              Admin Login
            </a>
          @endif
        </li>

      </ul>
    </div>
  </div>
</nav>

<section class="py-5 about-gradient">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-8 col-md-10">
        <h1 class="fw-bold text-center mb-4">About Candid Chronicles</h1>
        <p class="lead text-muted text-center mb-5">
          Welcome to <strong>Candid Chronicles</strong>, a space where curiosity meets clarity, and every story finds its voice.
        </p>

        <p>
          My name is <strong>Henry</strong>, and I’m the mind behind this blog. I created Candid Chronicles with a simple yet powerful mission: to explore life in its full spectrum — from the everyday to the extraordinary. Whether it’s culture, technology, personal growth, global affairs, or the quiet wisdom of daily living, this blog is a canvas for honest reflection and thoughtful conversation.
        </p>

        <p>
          I believe that knowledge should be accessible, stories should be shared, and perspectives should be respected. That’s why Candid Chronicles isn’t confined to one niche — it’s a living archive of insights, ideas, and inspiration drawn from all walks of life.
        </p>

        <p>
          I write to connect. To spark thought. To offer clarity in a noisy world. Every post is crafted with care, aiming to inform, inspire, or simply make you pause and think.
        </p>

        <p class="mb-4">
          Whether you're here to read, reflect, or just roam, I’m glad you stopped by. This blog is as much yours as it is mine — a shared space for learning, storytelling, and discovery.
        </p>

        <p class="text-end fw-semibold">Warmly,<br>Henry</p>

        <div class="text-center mt-4">
          <a href="{{ route('posts.index') }}" class="btn btn-secondary">← Back to Home</a>
        </div>
      </div>
    </div>
  </div>
</section>

<footer class="py-4 bg-dark text-light mt-auto">
  <div class="container d-flex flex-column flex-md-row justify-content-between align-items-center">
    <div>
      © {{ date('Y') }} Candid Chronicles. All rights reserved.
    </div>
    <div class="mt-2 mt-md-0">
      <a href="https://twitter.com/CandidChro4351" class="text-light text-decoration-none me-3">Twitter</a>
      <a href="https://www.instagram.com/candid_chronicles00/" class="text-light text-decoration-none me-3">Instagram</a>
      <a href="https://www.facebook.com/share/1CW8Pn4ws9/?mibextid=wwXIfr" class="text-light text-decoration-none">Facebook</a>
    </div>
    <div class="mt-2 mt-md-0">
    <a href="{{ route('privacy.policy') }}">Privacy Policy</a>
|
<a href="{{ route('terms') }}">Terms & Conditions</a>
  |
<a href="{{ route('contact') }}">Contact</a>
</div>

  </div>
  
</footer>

{{-- Bootstrap JS (required for navbar toggle + dropdowns) --}}
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
