<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ContactController extends Controller
{
    // Show contact page
    public function show()
    {
        return view('pages.contact');
    }

    // Handle contact form submit
    public function send(Request $request)
    {
        $data = $request->validate([
            'name'    => 'required|string|max:255',
            'email'   => 'required|email',
            'subject' => 'required|string|max:255',
            'message' => 'required|string|min:10',
        ]);

        // Send email to you
        Mail::raw(
            "New message from {$data['name']} ({$data['email']})\n\nSubject: {$data['subject']}\n\nMessage:\n{$data['message']}",
            function ($mail) use ($data) {
                $mail->to('henrychinaza23@gmail.com') // <-- change to your real email
                     ->subject('Contact Form: ' . $data['subject']);
            }
        );

        return back()->with('success', 'Thank you! Your message has been sent.');
    }
}
